/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.animal;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide2;
import lotr.common.entity.animal.LOTRAmbientCreature;
import lotr.common.entity.animal.LOTRAmbientSpawnChecks;
import lotr.common.entity.npc.LOTREntityAngbandBalrog;
import lotr.common.entity.npc.LOTREntityBalrog;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class LOTREntitySwan
extends EntityCreature
implements LOTRAmbientCreature {
    public float flapPhase;
    public float flapPower;
    public float prevFlapPower;
    public float prevFlapPhase;
    public float flapAccel = 1.0f;
    private int peckTime;
    private int peckLength;
    private int timeUntilHiss;
    private static Random violenceRand = new Random();
    private boolean assignedAttackOrFlee = false;
    private EntityAIBase attackAI = new LOTREntityAIAttackOnCollide2(this, 1.4, true);
    private EntityAIBase fleeAI = new EntityAIPanic((EntityCreature)this, 1.8);
    private IEntitySelector swanAttackRange = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity instanceof EntityLivingBase && entity.func_70089_S() && LOTREntitySwan.this.func_70068_e(entity) < 16.0;
        }
    };
    private static boolean wreckBalrogs = false;

    public LOTREntitySwan(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.7f);
        this.func_70661_as().func_75491_a(false);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, this.attackAI);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 10.0f, 0.05f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        if (wreckBalrogs) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, LOTREntityBalrog.class, 0, true));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, LOTREntityAngbandBalrog.class, 0, true));
        }
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, this.swanAttackRange));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void func_70636_d() {
        EntityLivingBase target;
        super.func_70636_d();
        this.prevFlapPhase = this.flapPhase;
        this.prevFlapPower = this.flapPower;
        this.flapPower += this.field_70122_E ? -0.02f : 0.05f;
        this.flapPower = Math.max(0.0f, Math.min(this.flapPower, 1.0f));
        if (!this.field_70122_E) {
            this.flapAccel = 0.6f;
        }
        this.flapPhase += this.flapAccel;
        this.flapAccel *= 0.95f;
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70171_ac && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.01;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && (!(target = this.func_70638_az()).func_70089_S() || target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75098_d)) {
            this.func_70624_b(null);
        }
        if (this.peckLength > 0) {
            ++this.peckTime;
            if (this.peckTime >= this.peckLength) {
                this.peckTime = 0;
                this.peckLength = 0;
            }
        } else {
            this.peckTime = 0;
        }
    }

    private boolean isViolentSwan() {
        long seed = this.func_110124_au().getLeastSignificantBits();
        violenceRand.setSeed(seed);
        return violenceRand.nextBoolean();
    }

    public void func_70619_bc() {
        if (!this.assignedAttackOrFlee) {
            this.field_70714_bg.func_85156_a(this.attackAI);
            this.field_70714_bg.func_85156_a(this.fleeAI);
            boolean violent = this.isViolentSwan();
            if (violent) {
                this.field_70714_bg.func_75776_a(1, this.attackAI);
            } else {
                this.field_70714_bg.func_75776_a(1, this.fleeAI);
            }
            this.assignedAttackOrFlee = true;
        }
        super.func_70619_bc();
        if (this.timeUntilHiss <= 0) {
            double range;
            List nearbyPlayers;
            if (this.func_70638_az() == null && this.field_70146_Z.nextInt(3) == 0 && !(nearbyPlayers = this.field_70170_p.func_82733_a(EntityPlayer.class, this.field_70121_D.func_72314_b(8.0, range = 8.0, range), LOTRMod.selectNonCreativePlayers())).isEmpty()) {
                EntityPlayer entityplayer = (EntityPlayer)nearbyPlayers.get(this.field_70146_Z.nextInt(nearbyPlayers.size()));
                this.func_70661_as().func_75499_g();
                float hissLook = (float)Math.toDegrees(Math.atan2(entityplayer.field_70161_v - this.field_70161_v, entityplayer.field_70165_t - this.field_70165_t));
                this.field_70759_as = hissLook -= 90.0f;
                this.field_70177_z = hissLook;
                this.field_70170_p.func_72960_a((Entity)this, (byte)21);
                this.func_85030_a("lotr:swan.hiss", this.func_70599_aP(), this.func_70647_i());
                this.timeUntilHiss = 80 + this.field_70146_Z.nextInt(80);
            }
        } else {
            --this.timeUntilHiss;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 20) {
            this.peckLength = 10;
        } else if (b == 21) {
            this.peckLength = 40;
        } else {
            super.func_70103_a(b);
        }
    }

    public float getPeckAngle(float tick) {
        if (this.peckLength == 0) {
            return 0.0f;
        }
        float peck = ((float)this.peckTime + tick) / (float)this.peckLength;
        float cutoff = 0.2f;
        if (peck < cutoff) {
            return peck / cutoff;
        }
        if (peck < 1.0f - cutoff) {
            return 1.0f;
        }
        return (1.0f - peck) / cutoff;
    }

    public boolean func_70652_k(Entity entity) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (wreckBalrogs && (entity instanceof LOTREntityBalrog || entity instanceof LOTREntityAngbandBalrog)) {
            f *= 50.0f;
        }
        if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)20);
            if (wreckBalrogs && (entity instanceof LOTREntityBalrog || entity instanceof LOTREntityAngbandBalrog)) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 2.0f), 0.2, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 2.0f));
                this.func_70015_d(0);
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damagesource, float f) {
        Entity entity = damagesource.func_76346_g();
        if (wreckBalrogs && (entity instanceof LOTREntityBalrog || entity instanceof LOTREntityAngbandBalrog)) {
            f /= 20.0f;
        }
        if (super.func_70097_a(damagesource, f)) {
            if (wreckBalrogs && (entity instanceof LOTREntityBalrog || entity instanceof LOTREntityAngbandBalrog)) {
                this.func_70015_d(0);
            }
            return true;
        }
        return false;
    }

    protected void func_70069_a(float f) {
    }

    public void func_70628_a(boolean flag, int i) {
        int feathers = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + i);
        for (int l = 0; l < feathers; ++l) {
            this.func_145779_a(LOTRMod.swanFeather, 1);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("wreckBalrogs", wreckBalrogs);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        wreckBalrogs = nbt.func_74767_n("wreckBalrogs");
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            return LOTRAmbientSpawnChecks.canSpawn((EntityLiving)this, 16, 8, 40, 2, Material.field_151586_h);
        }
        return false;
    }

    public float func_70783_a(int i, int j, int k) {
        return this.field_70170_p.func_147439_a(i, j - 1, k) == this.field_70170_p.func_72807_a((int)i, (int)k).field_76752_A ? 10.0f : this.field_70170_p.func_72801_o(i, j, k) - 0.5f;
    }

    protected int func_70693_a(EntityPlayer entityplayer) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(2);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(LOTRMod.spawnEgg, 1, LOTREntities.getEntityID((Entity)this));
    }
}

